import { u as useUserSession, R as ROLES, d as _sfc_main$5 } from "./index.591f3bfe.js";
import { _ as _sfc_main$6 } from "./VButtons.79021ab7.js";
import { _ as _sfc_main$7 } from "./KanbanDropdown.34128966.js";
import { _ as _sfc_main$3 } from "./VPlaceloadText.58d57dbf.js";
import { _ as _sfc_main$4 } from "./VLoader.3dcc431b.js";
import { G as defineStore, d as defineComponent, r as ref, o as openBlock, b as createElementBlock, m as createBaseVNode, B as toDisplayString, s as createVNode, y as withCtx, Z as createCommentVNode, E as createBlock, F as Fragment, z as createTextVNode, a5 as onMounted, a3 as watch, q as unref, n as normalizeClass, Y as renderList, D as useHead } from "./vendor.dd48a589.js";
import { b as useMesaSession, C as COMMAND_BAR, c as COMMAND_KITCHEN, M as MesaService, a as use, u as useCompanySession, S as STATUS_NEW, d as STATUS_RECEIVED, e as STATUS_PROCESSING, f as STATUS_TO_DELIVER, g as STATUS_DELIVERED } from "./mesaService.a6ec9502.js";
import { p as pageTitle } from "./sidebarLayoutState.bc85911b.js";
import "./VDropdown.2573bd4c.js";
import "./VIcon.dd77c06e.js";
const { getMesas2 } = useMesaSession();
const useCommandSession = defineStore("commandSession", () => {
  function productStatusFilter(status, command_type) {
    const products = [];
    if (command_type == "kitchen") {
      getMesas2().forEach((mesa) => {
        mesa.products.forEach((item) => {
          const newItem = item;
          newItem.mesa = mesa.id;
          newItem.statusKitchen === status ? products.push(newItem) : "";
        });
      });
    } else {
      getMesas2().forEach((mesa) => {
        mesa.products.forEach((item) => {
          const newItem = item;
          newItem.mesa = mesa.id;
          newItem.statusBar === status ? products.push(newItem) : "";
        });
      });
    }
    return products;
  }
  async function changeStatus(product, type) {
    const mesa = getMesas2().find((mesa2) => mesa2.id == product.mesa);
    mesa && mesa.products.forEach(async (item) => {
      if (type.code === COMMAND_BAR.code) {
        product.id == item.id ? item.statusBar = item.statusBar + 1 : "";
      }
      if (type.code === COMMAND_KITCHEN.code) {
        product.id == item.id ? item.statusKitchen = item.statusKitchen + 1 : "";
      }
    });
    if (mesa) {
      await MesaService.saveMesa(mesa);
      use.updateTable(mesa);
    }
  }
  return {
    productStatusFilter,
    changeStatus
  };
});
var CommandProduct_vue_vue_type_style_index_0_lang = "";
const _hoisted_1$2 = { class: "card-header" };
const _hoisted_2$1 = { class: "card-header-title m-0 is-dark-light" };
const _hoisted_3$1 = { class: "card-body p-0" };
const _hoisted_4$1 = { class: "table-container" };
const _hoisted_5$1 = { class: "table-container" };
const _hoisted_6$1 = { class: "table is-striped is-narrow is-hoverable is-fullwidth has-text-grey" };
const _hoisted_7$1 = { key: 0 };
const _hoisted_8$1 = { class: "has-text-danger" };
const _hoisted_9$1 = { class: "has-text-right" };
const _hoisted_10$1 = /* @__PURE__ */ createTextVNode(" Cantidad: ");
const _hoisted_11$1 = { class: "card-footer" };
const _hoisted_12$1 = /* @__PURE__ */ createBaseVNode("br", null, null, -1);
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  props: {
    product: { type: null, required: true, default: Object },
    view: { type: null, required: true, default: Object }
  },
  emits: ["setProducts"],
  setup(__props, { emit }) {
    const props = __props;
    const loading = ref(false);
    const isLoaderActive = ref(false);
    const commandSession = useCommandSession();
    const changeStatus = async () => {
      loading.value = true;
      await commandSession.changeStatus(props.product, props.view);
      emit("setProducts");
      loading.value = false;
    };
    return (_ctx, _cache) => {
      const _component_VPlaceloadText = _sfc_main$3;
      const _component_VLoader = _sfc_main$4;
      return openBlock(), createElementBlock(Fragment, null, [
        createBaseVNode("div", _hoisted_1$2, [
          createBaseVNode("p", _hoisted_2$1, " Mesa " + toDisplayString(props.product.mesa), 1)
        ]),
        createVNode(_component_VLoader, {
          size: "small",
          active: isLoaderActive.value,
          translucent: ""
        }, {
          default: withCtx(() => [
            createBaseVNode("div", _hoisted_3$1, [
              createBaseVNode("div", _hoisted_4$1, [
                createBaseVNode("div", _hoisted_5$1, [
                  createBaseVNode("table", _hoisted_6$1, [
                    createBaseVNode("tr", null, [
                      createBaseVNode("td", null, toDisplayString(props.product.name), 1)
                    ]),
                    props.product.note ? (openBlock(), createElementBlock("tr", _hoisted_7$1, [
                      createBaseVNode("td", _hoisted_8$1, toDisplayString(props.product.note), 1)
                    ])) : createCommentVNode("", true),
                    createBaseVNode("tr", null, [
                      createBaseVNode("td", _hoisted_9$1, [
                        _hoisted_10$1,
                        createBaseVNode("span", null, toDisplayString(props.product.quantity), 1)
                      ])
                    ])
                  ])
                ])
              ])
            ]),
            createBaseVNode("footer", _hoisted_11$1, [
              loading.value ? (openBlock(), createBlock(_component_VPlaceloadText, {
                key: 0,
                lines: 1,
                width: "100%",
                "last-line-width": "25%"
              })) : (openBlock(), createElementBlock("a", {
                key: 1,
                class: "card-footer-item has-text-secondary",
                onClick: _cache[0] || (_cache[0] = ($event) => changeStatus())
              }, " Siguiente ")),
              _hoisted_12$1
            ])
          ]),
          _: 1
        }, 8, ["active"])
      ], 64);
    };
  }
});
var CommandRestaurant_vue_vue_type_style_index_0_lang = "";
const _hoisted_1$1 = { class: "page-content kanban-content is-relative" };
const _hoisted_2 = { class: "columns is-multiline is-mobile" };
const _hoisted_3 = { class: "column is-6" };
const _hoisted_4 = { class: "column is-half has-text-right has-text-dark" };
const _hoisted_5 = { class: "columns is-kanban-wrapper" };
const _hoisted_6 = { class: "collapsed-content" };
const _hoisted_7 = /* @__PURE__ */ createBaseVNode("i", {
  "aria-hidden": "true",
  class: "iconify",
  "data-icon": "feather:plus"
}, null, -1);
const _hoisted_8 = [
  _hoisted_7
];
const _hoisted_9 = { class: "task-count" };
const _hoisted_10 = /* @__PURE__ */ createBaseVNode("div", { class: "collapsed-text" }, "Recibidos", -1);
const _hoisted_11 = { class: "expanded-content" };
const _hoisted_12 = { class: "column-title" };
const _hoisted_13 = /* @__PURE__ */ createBaseVNode("input", {
  type: "text",
  class: "input is-small rename-input is-hidden"
}, null, -1);
const _hoisted_14 = /* @__PURE__ */ createBaseVNode("span", { class: "column-name" }, [
  /* @__PURE__ */ createBaseVNode("i", { class: "fas fa-circle has-text-secondary" }),
  /* @__PURE__ */ createTextVNode(" Recibidos ")
], -1);
const _hoisted_15 = { class: "task-count" };
const _hoisted_16 = {
  key: 0,
  class: "kanban-empty"
};
const _hoisted_17 = { class: "empty-text" };
const _hoisted_18 = ["data-id"];
const _hoisted_19 = { class: "collapsed-content" };
const _hoisted_20 = /* @__PURE__ */ createBaseVNode("i", {
  "aria-hidden": "true",
  class: "iconify",
  "data-icon": "feather:plus"
}, null, -1);
const _hoisted_21 = [
  _hoisted_20
];
const _hoisted_22 = { class: "task-count" };
const _hoisted_23 = /* @__PURE__ */ createBaseVNode("div", { class: "collapsed-text" }, "Preparando", -1);
const _hoisted_24 = { class: "expanded-content" };
const _hoisted_25 = { class: "column-title" };
const _hoisted_26 = /* @__PURE__ */ createBaseVNode("input", {
  type: "text",
  class: "input is-small rename-input is-hidden"
}, null, -1);
const _hoisted_27 = /* @__PURE__ */ createBaseVNode("span", { class: "column-name" }, [
  /* @__PURE__ */ createBaseVNode("i", { class: "fas fa-circle has-text-secondary" }),
  /* @__PURE__ */ createTextVNode(" Preparando ")
], -1);
const _hoisted_28 = { class: "task-count" };
const _hoisted_29 = {
  key: 0,
  class: "kanban-empty"
};
const _hoisted_30 = { class: "empty-text" };
const _hoisted_31 = ["data-id"];
const _hoisted_32 = { class: "collapsed-content" };
const _hoisted_33 = /* @__PURE__ */ createBaseVNode("i", {
  "aria-hidden": "true",
  class: "iconify",
  "data-icon": "feather:plus"
}, null, -1);
const _hoisted_34 = [
  _hoisted_33
];
const _hoisted_35 = { class: "task-count" };
const _hoisted_36 = /* @__PURE__ */ createBaseVNode("div", { class: "collapsed-text" }, "Por entregar", -1);
const _hoisted_37 = { class: "expanded-content" };
const _hoisted_38 = { class: "column-title" };
const _hoisted_39 = /* @__PURE__ */ createBaseVNode("input", {
  type: "text",
  class: "input is-small rename-input is-hidden"
}, null, -1);
const _hoisted_40 = /* @__PURE__ */ createBaseVNode("span", { class: "column-name" }, [
  /* @__PURE__ */ createBaseVNode("i", { class: "fas fa-circle has-text-secondary" }),
  /* @__PURE__ */ createTextVNode(" Por entregar ")
], -1);
const _hoisted_41 = { class: "task-count" };
const _hoisted_42 = {
  key: 0,
  class: "kanban-empty"
};
const _hoisted_43 = { class: "empty-text" };
const _hoisted_44 = ["data-id"];
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  setup(__props) {
    const userSession = useUserSession();
    const roleCurrent = userSession.userRole;
    const role = ROLES.find((role2) => role2.id === roleCurrent);
    const disableBar = ref(true);
    const disableKitchen = ref(true);
    const mesas = useMesaSession().mesas;
    const defaultView = () => {
      let response = COMMAND_KITCHEN;
      if (role && role.id != 3) {
        if (role.code == "BAR") {
          response = COMMAND_BAR;
          disableBar.value = false;
        }
        if (role.code == "KIT") {
          response = COMMAND_KITCHEN;
          disableKitchen.value = false;
        }
      }
      if ((role == null ? void 0 : role.id) == 3) {
        disableBar.value = false;
        disableKitchen.value = false;
      }
      return response;
    };
    let currentView = ref(defaultView());
    const isColumnPreparationCollapsed = ref(false);
    const isColumnDispatchedCollapsed = ref(false);
    const isColumnDeliveredCollapsed = ref(false);
    const isLoaderActive = ref(false);
    const emptyText = ref("No existe registro actualmente");
    const commandSession = useCommandSession();
    let productsStatusNew = ref([]);
    let productsStatusReceived = ref([]);
    let productsStatusProcessing = ref([]);
    let productsStatusToDeliver = ref([]);
    let productsStatusDelivered = ref([]);
    const companySession = useCompanySession();
    const configuration = companySession.configuration;
    const setProducts = () => {
      productsStatusNew.value = commandSession.productStatusFilter(STATUS_NEW.id, currentView.value.code);
      productsStatusReceived.value = commandSession.productStatusFilter(STATUS_RECEIVED.id, currentView.value.code);
      productsStatusProcessing.value = commandSession.productStatusFilter(STATUS_PROCESSING.id, currentView.value.code);
      productsStatusToDeliver.value = commandSession.productStatusFilter(STATUS_TO_DELIVER.id, currentView.value.code);
      productsStatusDelivered.value = commandSession.productStatusFilter(STATUS_DELIVERED.id, currentView.value.code);
    };
    const changeView = (view) => {
      currentView.value = view;
      setProducts();
    };
    onMounted(() => {
      changeView(currentView.value);
    });
    watch(mesas, () => {
      setProducts();
    });
    return (_ctx, _cache) => {
      const _component_VButton = _sfc_main$5;
      const _component_VButtons = _sfc_main$6;
      const _component_KanbanDropdown = _sfc_main$7;
      const _component_CommandProduct = _sfc_main$2;
      const _component_VLoader = _sfc_main$4;
      return openBlock(), createElementBlock("div", _hoisted_1$1, [
        createBaseVNode("div", _hoisted_2, [
          createBaseVNode("div", _hoisted_3, [
            createVNode(_component_VButtons, null, {
              default: withCtx(() => [
                unref(configuration).menu_bar ? (openBlock(), createBlock(_component_VButton, {
                  key: 0,
                  icon: "fas fa-glass-martini-alt",
                  color: unref(currentView).code == unref(COMMAND_BAR).code && "primary",
                  disabled: disableBar.value,
                  onClick: _cache[0] || (_cache[0] = ($event) => changeView(unref(COMMAND_BAR)))
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(unref(COMMAND_BAR).name), 1)
                  ]),
                  _: 1
                }, 8, ["color", "disabled"])) : createCommentVNode("", true),
                unref(configuration).menu_kitchen ? (openBlock(), createBlock(_component_VButton, {
                  key: 1,
                  icon: "fas fa-concierge-bell",
                  color: unref(currentView).code == unref(COMMAND_KITCHEN).code && "primary",
                  disabled: disableKitchen.value,
                  onClick: _cache[1] || (_cache[1] = ($event) => changeView(unref(COMMAND_KITCHEN)))
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(unref(COMMAND_KITCHEN).name), 1)
                  ]),
                  _: 1
                }, 8, ["color", "disabled"])) : createCommentVNode("", true)
              ]),
              _: 1
            })
          ]),
          createBaseVNode("div", _hoisted_4, [
            createBaseVNode("h3", null, toDisplayString(unref(currentView).name), 1)
          ])
        ]),
        createBaseVNode("div", _hoisted_5, [
          createBaseVNode("div", {
            class: normalizeClass(["column", [
              isColumnPreparationCollapsed.value && "is-1 is-mini",
              !isColumnPreparationCollapsed.value && "is-one-third"
            ]])
          }, [
            createVNode(_component_VLoader, {
              size: "small",
              active: isLoaderActive.value,
              translucent: ""
            }, {
              default: withCtx(() => [
                createBaseVNode("div", {
                  class: normalizeClass(["kanban-column", [isColumnPreparationCollapsed.value && "is-collapsed"]])
                }, [
                  createBaseVNode("div", _hoisted_6, [
                    createBaseVNode("div", {
                      class: "expand-button",
                      onClick: _cache[2] || (_cache[2] = ($event) => isColumnPreparationCollapsed.value = false)
                    }, _hoisted_8),
                    createBaseVNode("div", null, [
                      createBaseVNode("span", _hoisted_9, toDisplayString(unref(productsStatusReceived).length), 1)
                    ]),
                    _hoisted_10
                  ]),
                  createBaseVNode("div", _hoisted_11, [
                    createBaseVNode("div", _hoisted_12, [
                      _hoisted_13,
                      createBaseVNode("h3", null, [
                        _hoisted_14,
                        createBaseVNode("span", _hoisted_15, toDisplayString(unref(productsStatusReceived).length), 1)
                      ]),
                      createVNode(_component_KanbanDropdown, {
                        onCollapse: _cache[3] || (_cache[3] = ($event) => isColumnPreparationCollapsed.value = true)
                      })
                    ]),
                    createBaseVNode("div", {
                      ref: (_value, _refs) => {
                        _refs["newContainer"] = _value;
                      },
                      "data-state": "preparation"
                    }, [
                      unref(productsStatusReceived).length === 0 ? (openBlock(), createElementBlock("div", _hoisted_16, [
                        createBaseVNode("p", _hoisted_17, toDisplayString(emptyText.value), 1)
                      ])) : createCommentVNode("", true),
                      (openBlock(true), createElementBlock(Fragment, null, renderList(unref(productsStatusReceived), (item, index) => {
                        return openBlock(), createElementBlock("div", {
                          key: index,
                          "data-id": item.id,
                          class: "kanban-card is-new"
                        }, [
                          createVNode(_component_CommandProduct, {
                            product: item,
                            view: unref(currentView),
                            onSetProducts: setProducts
                          }, null, 8, ["product", "view"])
                        ], 8, _hoisted_18);
                      }), 128))
                    ], 512)
                  ])
                ], 2)
              ]),
              _: 1
            }, 8, ["active"])
          ], 2),
          createBaseVNode("div", {
            class: normalizeClass(["column", [
              isColumnDispatchedCollapsed.value && "is-1 is-mini",
              !isColumnDispatchedCollapsed.value && "is-one-third"
            ]])
          }, [
            createVNode(_component_VLoader, {
              size: "small",
              active: isLoaderActive.value,
              translucent: ""
            }, {
              default: withCtx(() => [
                createBaseVNode("div", {
                  class: normalizeClass(["kanban-column", [isColumnDispatchedCollapsed.value && "is-collapsed"]])
                }, [
                  createBaseVNode("div", _hoisted_19, [
                    createBaseVNode("div", {
                      class: "expand-button",
                      onClick: _cache[4] || (_cache[4] = ($event) => isColumnDispatchedCollapsed.value = false)
                    }, _hoisted_21),
                    createBaseVNode("div", null, [
                      createBaseVNode("span", _hoisted_22, toDisplayString(unref(productsStatusProcessing).length), 1)
                    ]),
                    _hoisted_23
                  ]),
                  createBaseVNode("div", _hoisted_24, [
                    createBaseVNode("div", _hoisted_25, [
                      _hoisted_26,
                      createBaseVNode("h3", null, [
                        _hoisted_27,
                        createBaseVNode("span", _hoisted_28, toDisplayString(unref(productsStatusProcessing).length), 1)
                      ]),
                      createVNode(_component_KanbanDropdown, {
                        onCollapse: _cache[5] || (_cache[5] = ($event) => isColumnDispatchedCollapsed.value = true)
                      })
                    ]),
                    createBaseVNode("div", {
                      ref: (_value, _refs) => {
                        _refs["newContainer"] = _value;
                      },
                      "data-state": "preparation"
                    }, [
                      unref(productsStatusProcessing).length === 0 ? (openBlock(), createElementBlock("div", _hoisted_29, [
                        createBaseVNode("p", _hoisted_30, toDisplayString(emptyText.value), 1)
                      ])) : createCommentVNode("", true),
                      (openBlock(true), createElementBlock(Fragment, null, renderList(unref(productsStatusProcessing), (item, index) => {
                        return openBlock(), createElementBlock("div", {
                          key: index,
                          "data-id": item.id,
                          class: "kanban-card is-new"
                        }, [
                          createVNode(_component_CommandProduct, {
                            product: item,
                            view: unref(currentView),
                            onSetProducts: setProducts
                          }, null, 8, ["product", "view"])
                        ], 8, _hoisted_31);
                      }), 128))
                    ], 512)
                  ])
                ], 2)
              ]),
              _: 1
            }, 8, ["active"])
          ], 2),
          createBaseVNode("div", {
            class: normalizeClass(["column", [
              isColumnDeliveredCollapsed.value && "is-1 is-mini",
              !isColumnDeliveredCollapsed.value && "is-one-third"
            ]])
          }, [
            createVNode(_component_VLoader, {
              size: "small",
              active: isLoaderActive.value,
              translucent: ""
            }, {
              default: withCtx(() => [
                createBaseVNode("div", {
                  class: normalizeClass(["kanban-column", [isColumnDeliveredCollapsed.value && "is-collapsed"]])
                }, [
                  createBaseVNode("div", _hoisted_32, [
                    createBaseVNode("div", {
                      class: "expand-button",
                      onClick: _cache[6] || (_cache[6] = ($event) => isColumnDeliveredCollapsed.value = false)
                    }, _hoisted_34),
                    createBaseVNode("div", null, [
                      createBaseVNode("span", _hoisted_35, toDisplayString(unref(productsStatusToDeliver).length), 1)
                    ]),
                    _hoisted_36
                  ]),
                  createBaseVNode("div", _hoisted_37, [
                    createBaseVNode("div", _hoisted_38, [
                      _hoisted_39,
                      createBaseVNode("h3", null, [
                        _hoisted_40,
                        createBaseVNode("span", _hoisted_41, toDisplayString(unref(productsStatusToDeliver).length), 1)
                      ]),
                      createVNode(_component_KanbanDropdown, {
                        onCollapse: _cache[7] || (_cache[7] = ($event) => isColumnDeliveredCollapsed.value = true)
                      })
                    ]),
                    createBaseVNode("div", {
                      ref: (_value, _refs) => {
                        _refs["newContainer"] = _value;
                      },
                      "data-state": "preparation"
                    }, [
                      unref(productsStatusToDeliver).length === 0 ? (openBlock(), createElementBlock("div", _hoisted_42, [
                        createBaseVNode("p", _hoisted_43, toDisplayString(emptyText.value), 1)
                      ])) : createCommentVNode("", true),
                      (openBlock(true), createElementBlock(Fragment, null, renderList(unref(productsStatusToDeliver), (item, index) => {
                        return openBlock(), createElementBlock("div", {
                          key: index,
                          "data-id": item.id,
                          class: "kanban-card is-new"
                        }, [
                          createVNode(_component_CommandProduct, {
                            product: item,
                            view: unref(currentView),
                            onSetProducts: setProducts
                          }, null, 8, ["product", "view"])
                        ], 8, _hoisted_44);
                      }), 128))
                    ], 512)
                  ])
                ], 2)
              ]),
              _: 1
            }, 8, ["active"])
          ], 2)
        ])
      ]);
    };
  }
});
const _hoisted_1 = { class: "page-content-inner" };
const _sfc_main = /* @__PURE__ */ defineComponent({
  setup(__props) {
    pageTitle.value = "Pedidos";
    useHead({
      title: "Pedidos"
    });
    return (_ctx, _cache) => {
      const _component_CommandRestaurant = _sfc_main$1;
      return openBlock(), createElementBlock("div", _hoisted_1, [
        createVNode(_component_CommandRestaurant)
      ]);
    };
  }
});
export { _sfc_main as default };
