import { d as defineComponent, a as useRouter, r as ref, o as openBlock, b as createElementBlock, af as useRoute, X as reactive, D as useHead, a5 as onMounted, A as resolveComponent, s as createVNode, m as createBaseVNode, y as withCtx, p as withModifiers, K as axios, t as withDirectives, ah as vModelSelect, F as Fragment, Y as renderList, B as toDisplayString, ag as vModelText, q as unref, z as createTextVNode } from "./vendor.4b7a2e6c.js";
import { _ as _export_sfc, u as useUserSession, N as NAME_ROUTE_POS, R as ROLES, p as provideApi, c as useNotyf, b as _sfc_main$3 } from "./index.33831081.js";
import { _ as __unplugin_components_1 } from "./VControl.87ec9af6.js";
import { _ as _sfc_main$2 } from "./VField.afaabb17.js";
import { M as MasterService } from "./masterService.1efb8c53.js";
import { u as useCompanySession, a as use } from "./mesaService.51000732.js";
var _imports_0 = "/isotipo-oficial.png";
var AnimatedLogo_vue_vue_type_style_index_0_scoped_true_lang = "";
const _hoisted_1$1 = {
  src: _imports_0,
  alt: "logo"
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  props: {
    light: { type: Boolean, required: false }
  },
  setup(__props) {
    const router = useRouter();
    const isLoading = ref(false);
    router.beforeEach(() => {
      isLoading.value = true;
    });
    router.afterEach(() => {
      setTimeout(() => {
        isLoading.value = false;
      }, 200);
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("img", _hoisted_1$1);
    };
  }
});
var __unplugin_components_0 = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["__scopeId", "data-v-427b10f0"]]);
var mozo_vue_vue_type_style_index_0_lang = "";
const _hoisted_1 = { class: "auth-wrapper-inner is-single" };
const _hoisted_2 = { class: "auth-nav" };
const _hoisted_3 = /* @__PURE__ */ createBaseVNode("div", { class: "left" }, null, -1);
const _hoisted_4 = { class: "center" };
const _hoisted_5 = /* @__PURE__ */ createBaseVNode("div", { class: "right" }, null, -1);
const _hoisted_6 = { class: "single-form-wrap is-relative" };
const _hoisted_7 = { class: "inner-wrap" };
const _hoisted_8 = { class: "auth-head" };
const _hoisted_9 = /* @__PURE__ */ createBaseVNode("h2", null, "Listado de mozos", -1);
const _hoisted_10 = { class: "select" };
const _hoisted_11 = ["value"];
const _hoisted_12 = { class: "form-card" };
const _hoisted_13 = ["onSubmit"];
const _hoisted_14 = { class: "login-form" };
const _hoisted_15 = /* @__PURE__ */ createTextVNode(" Ingresar ");
const _sfc_main = /* @__PURE__ */ defineComponent({
  setup(__props) {
    const isLoading = ref(false);
    const router = useRouter();
    const route = useRoute();
    const notif = useNotyf();
    const userSession = useUserSession();
    const companySession = useCompanySession();
    const redirect = route.query.redirect;
    const waiters = ref([]);
    const selectedWaiterEmail = ref("");
    const user = reactive({
      email: "demo@gmail.com",
      password: "123456",
      domain: "restaurante.facturalo.pro",
      ssl: "https://"
    });
    if (userSession.url) {
      user.domain = userSession.url;
    }
    if (userSession.email) {
      user.email = userSession.email;
    }
    if (userSession.pwd) {
      user.password = userSession.pwd;
    }
    const handleLogin = async () => {
      try {
        user.email = selectedWaiterEmail.value;
        isLoading.value = true;
        notif.sync(`Sincronizando informaci\xF3n`);
        const response = await axios.post(`${user.ssl + user.domain}/api/login`, user);
        if (response.data.success) {
          const {
            email,
            logo,
            name,
            ruc,
            restaurant_role_code,
            establishment_id,
            seriedefault,
            success,
            token,
            company,
            sellerId
          } = response.data;
          const dataUser = {
            email,
            logo,
            name,
            ruc,
            restaurant_role_code,
            establishment_id,
            seriedefault,
            success,
            token,
            sellerId
          };
          userSession.setToken(dataUser.token);
          userSession.setEmail(dataUser.email);
          userSession.setName(dataUser.name);
          userSession.setUrl(user.domain);
          userSession.setPwd(user.password);
          userSession.setSsl(user.ssl);
          userSession.setEstablishmentId(dataUser.establishment_id);
          userSession.setIsBlockedPin(0);
          if (dataUser.sellerId) {
            userSession.setSellerId(dataUser.sellerId);
            userSession.setSellerName(dataUser.name);
          }
          if (dataUser.restaurant_role_code) {
            userSession.setRole(dataUser.restaurant_role_code);
          } else {
            userSession.setRole("NOTHING");
          }
          if (company) {
            userSession.setUrlLogo(company.url_logo);
            userSession.setLogoBase64(company.logo_base64);
          }
          use.connect();
          use.sendCompany();
          await MasterService.syncData();
          notif.dismissAll();
          notif.success(`Bienvenido, ${dataUser.name}`);
          let role = {
            id: 0,
            name: "POS",
            code: "POS",
            menu: NAME_ROUTE_POS
          };
          role = ROLES.find((role2) => role2.code === dataUser.restaurant_role_code);
          if (redirect) {
            router.push(redirect);
          } else if (dataUser.restaurant_role_code && role.code != "ADM") {
            router.push({
              name: role.menu
            });
          } else {
            router.push({
              name: companySession.firstMenu
            });
          }
        } else {
          notif.dismissAll();
          notif.error("Datos de usuario incorrectos.");
        }
      } catch (error) {
        notif.error("Ocurri\xF3 un error al ingresar.");
      } finally {
        isLoading.value = false;
      }
    };
    const getListWaiter = async () => {
      try {
        const response = await provideApi().get(`/restaurant/list-waiter`);
        const data = response.data;
        if (data.success) {
          console.log("MOZOS");
          console.log(data.data);
          waiters.value = data.data;
        }
      } catch (error) {
        console.error("Error data:", error);
      }
    };
    useHead({
      title: "Ingreso - Mozo.pe"
    });
    onMounted(async () => {
      const url = userSession.url;
      if (url) {
        user.domain = url;
      }
      getListWaiter();
    });
    return (_ctx, _cache) => {
      const _component_LandingGrids = resolveComponent("LandingGrids");
      const _component_AnimatedLogo = __unplugin_components_0;
      const _component_RouterLink = resolveComponent("RouterLink");
      const _component_VControl = __unplugin_components_1;
      const _component_VField = _sfc_main$2;
      const _component_VButton = _sfc_main$3;
      return openBlock(), createElementBlock("div", _hoisted_1, [
        createVNode(_component_LandingGrids, { class: "is-contrasted" }),
        createBaseVNode("div", _hoisted_2, [
          _hoisted_3,
          createBaseVNode("div", _hoisted_4, [
            createVNode(_component_RouterLink, {
              to: "/",
              class: "header-item"
            }, {
              default: withCtx(() => [
                createVNode(_component_AnimatedLogo, {
                  width: "38px",
                  height: "38px"
                })
              ]),
              _: 1
            })
          ]),
          _hoisted_5
        ]),
        createBaseVNode("div", _hoisted_6, [
          createBaseVNode("div", _hoisted_7, [
            createBaseVNode("div", _hoisted_8, [
              _hoisted_9,
              createVNode(_component_VField, null, {
                default: withCtx(() => [
                  createVNode(_component_VControl, null, {
                    default: withCtx(() => [
                      createBaseVNode("div", _hoisted_10, [
                        withDirectives(createBaseVNode("select", {
                          "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => selectedWaiterEmail.value = $event)
                        }, [
                          (openBlock(true), createElementBlock(Fragment, null, renderList(waiters.value, (waiter) => {
                            return openBlock(), createElementBlock("option", {
                              key: waiter.email,
                              value: waiter.email
                            }, toDisplayString(waiter.name), 9, _hoisted_11);
                          }), 128))
                        ], 512), [
                          [vModelSelect, selectedWaiterEmail.value]
                        ])
                      ])
                    ]),
                    _: 1
                  })
                ]),
                _: 1
              })
            ]),
            createBaseVNode("div", _hoisted_12, [
              createBaseVNode("form", {
                method: "post",
                novalidate: "",
                onSubmit: withModifiers(handleLogin, ["prevent"])
              }, [
                createBaseVNode("div", _hoisted_14, [
                  createVNode(_component_VField, null, {
                    default: withCtx(() => [
                      createVNode(_component_VControl, { icon: "feather:lock" }, {
                        default: withCtx(() => [
                          withDirectives(createBaseVNode("input", {
                            "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => unref(user).password = $event),
                            class: "input",
                            type: "password",
                            placeholder: "Pin",
                            autocomplete: "current-password"
                          }, null, 512), [
                            [vModelText, unref(user).password]
                          ])
                        ]),
                        _: 1
                      })
                    ]),
                    _: 1
                  }),
                  createVNode(_component_VControl, { class: "login" }, {
                    default: withCtx(() => [
                      createVNode(_component_VButton, {
                        loading: isLoading.value,
                        color: "primary",
                        type: "submit",
                        bold: "",
                        fullwidth: "",
                        raised: ""
                      }, {
                        default: withCtx(() => [
                          _hoisted_15
                        ]),
                        _: 1
                      }, 8, ["loading"])
                    ]),
                    _: 1
                  })
                ])
              ], 40, _hoisted_13)
            ])
          ])
        ])
      ]);
    };
  }
});
export { _sfc_main as default };
